package com.sdk.esc;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Toast;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;

import java.util.ArrayList;

import print.Print;
import print.UDPConnection;

public class Activity_UDP extends Activity {

    private RecyclerView recy_udp;
    private BaseQuickAdapter<String, BaseViewHolder> baseQuickAdapter;
    private ArrayList<String> strings;
    private Context mContext;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_udp);
        mContext = getApplicationContext();
        recy_udp = (RecyclerView) findViewById(R.id.recy_udp);
        strings = new ArrayList<String>();
        baseQuickAdapter = new BaseQuickAdapter<String, BaseViewHolder>(android.R.layout.simple_list_item_1, strings) {
            @Override
            protected void convert(BaseViewHolder helper, String item) {
                helper.setText(android.R.id.text1, item);
            }
        };
        recy_udp.setLayoutManager(new LinearLayoutManager(mContext));
//        recy_udp.addItemDecoration(new DividerItemDecoration(mContext, DividerItemDecoration.VERTICAL));
        recy_udp.setAdapter(baseQuickAdapter);
        baseQuickAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, final int position) {
                new Thread() {
                    @Override
                    public void run() {
                        super.run();
                        try {
                            Log.d("TAG", "IP:" + strings.get(position));
                            if (Print.PortOpen(mContext, "WiFi," + strings.get(position) + ",9100") == 0) {
                                Intent intent = new Intent();
                                intent.putExtra("is_connected", "OK");
                                setResult(Print.ACTIVITY_CONNECT_WIFI, intent);
                                finish();
                            } else {
                                runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
                                        Toast.makeText(mContext, getString(R.string.activity_main_connecterr), Toast.LENGTH_SHORT).show();
                                    }
                                });
                            }
                        } catch (Exception e) {
                            runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    Toast.makeText(mContext, getString(R.string.activity_main_connecterr), Toast.LENGTH_SHORT).show();
                                }
                            });
                        }
                    }
                }.start();
            }
        });
        UDPConnection.getUdpIP(mContext, new UDPConnection.setOnLister() {
            @Override
            public void getData(final String ip) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        strings.add(ip);
                        baseQuickAdapter.notifyDataSetChanged();
                    }
                });
            }
        });
    }
}
